% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/layout_htree.R
\name{layout_tbl_graph_htree}
\alias{layout_tbl_graph_htree}
\title{Layout binary trees in a fractal H formation}
\usage{
layout_tbl_graph_htree(
  graph,
  sort.by = NULL,
  direction = "out",
  circular = FALSE
)
}
\arguments{
\item{graph}{An \code{tbl_graph} object}

\item{sort.by}{The name of a node variable to sort the nodes by.}

\item{direction}{The direction of the tree in the graph. \code{'out'} (default)
means that parents point towards their children, while \code{'in'} means that
children point towards their parent.}

\item{circular}{Logical. Should the layout be transformed to a circular
representation. Ignored}
}
\value{
A data.frame with the columns \code{x}, \code{y}, \code{leaf}, \code{depth}, \code{circular}
as well as any information stored as node variables in the tbl_graph object.
}
\description{
This is a spac efficient layout only useful for binary trees. It is fractal
and works by offsetting child nodes from their parent either horizontally or
vertically depending on depth. The offset is decreased at each step by a
factor of the square root of 2.
}
\note{
H Tree is a layout intended for trees, that is, graphs where nodes
only have one parent and zero or more children. If the provided graph does
not fit this format an attempt to convert it to such a format will be made.
}
\seealso{
Other layout_tbl_graph_*: 
\code{\link{layout_tbl_graph_auto}()},
\code{\link{layout_tbl_graph_backbone}()},
\code{\link{layout_tbl_graph_cactustree}()},
\code{\link{layout_tbl_graph_centrality}()},
\code{\link{layout_tbl_graph_circlepack}()},
\code{\link{layout_tbl_graph_dendrogram}()},
\code{\link{layout_tbl_graph_eigen}()},
\code{\link{layout_tbl_graph_fabric}()},
\code{\link{layout_tbl_graph_focus}()},
\code{\link{layout_tbl_graph_hive}()},
\code{\link{layout_tbl_graph_igraph}()},
\code{\link{layout_tbl_graph_linear}()},
\code{\link{layout_tbl_graph_manual}()},
\code{\link{layout_tbl_graph_matrix}()},
\code{\link{layout_tbl_graph_metro}()},
\code{\link{layout_tbl_graph_partition}()},
\code{\link{layout_tbl_graph_pmds}()},
\code{\link{layout_tbl_graph_sf}()},
\code{\link{layout_tbl_graph_stress}()},
\code{\link{layout_tbl_graph_treemap}()},
\code{\link{layout_tbl_graph_unrooted}()}
}
\concept{layout_tbl_graph_*}
