# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from enum import Enum
from azure.core import CaseInsensitiveEnumMeta


class ActionType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Enum. Indicates the action type. "Internal" refers to actions that are for internal only APIs."""

    INTERNAL = "Internal"


class CreatedByType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The type of identity that created the resource."""

    USER = "User"
    APPLICATION = "Application"
    MANAGED_IDENTITY = "ManagedIdentity"
    KEY = "Key"


class ExperimentActionType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Enum union of Chaos experiment action types."""

    DELAY = "delay"
    DISCRETE = "discrete"
    CONTINUOUS = "continuous"


class FilterType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Enum that discriminates between filter types. Currently only ``Simple`` type is supported."""

    SIMPLE = "Simple"
    """Simple filter type."""


class ManagedServiceIdentityType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Type of managed service identity (where both SystemAssigned and UserAssigned types are
    allowed).
    """

    NONE = "None"
    SYSTEM_ASSIGNED = "SystemAssigned"
    USER_ASSIGNED = "UserAssigned"
    SYSTEM_ASSIGNED_USER_ASSIGNED = "SystemAssigned,UserAssigned"


class Origin(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The intended executor of the operation; as in Resource Based Access Control (RBAC) and audit
    logs UX. Default value is "user,system".
    """

    USER = "user"
    SYSTEM = "system"
    USER_SYSTEM = "user,system"


class ProvisioningState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Current provisioning state for a given Azure Chaos resource."""

    SUCCEEDED = "Succeeded"
    """Resource has been created."""
    FAILED = "Failed"
    """Resource creation failed."""
    CANCELED = "Canceled"
    """Resource creation was canceled."""
    CREATING = "Creating"
    """Initial creation in progress."""
    UPDATING = "Updating"
    """Update in progress."""
    DELETING = "Deleting"
    """Deletion in progress."""


class SelectorType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Enum of the selector type."""

    LIST = "List"
    """List selector type."""
    QUERY = "Query"
    """Query selector type."""


class TargetReferenceType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Enum of the Target reference type."""

    CHAOS_TARGET = "ChaosTarget"
    """Chaos target reference type."""
