; NOTE: Assertions have been autogenerated by utils/update_test_checks.py UTC_ARGS: --function-signature --check-attributes --check-globals
; RUN: opt -aa-pipeline=basic-aa -passes=attributor -attributor-manifest-internal  -attributor-annotate-decl-cs  -S < %s | FileCheck %s --check-prefixes=CHECK,TUNIT
; RUN: opt -aa-pipeline=basic-aa -passes=attributor-cgscc -attributor-manifest-internal  -attributor-annotate-decl-cs -S < %s | FileCheck %s --check-prefixes=CHECK,CGSCC

; Don't constant-propagate byval pointers, since they are not pointers!
; PR5038
%struct.MYstr = type { i8, i32 }
@mystr = internal global %struct.MYstr zeroinitializer ; <ptr> [#uses=3]

declare void @use(i8)
;.
; CHECK: @mystr = internal global %struct.MYstr zeroinitializer
;.
define internal void @vfu1(ptr byval(%struct.MYstr) align 4 %u) nounwind {
; CHECK: Function Attrs: nounwind memory(readwrite, argmem: none)
; CHECK-LABEL: define {{[^@]+}}@vfu1
; CHECK-SAME: (i8 [[TMP0:%.*]], i32 [[TMP1:%.*]]) #[[ATTR0:[0-9]+]] {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[U_PRIV:%.*]] = alloca [[STRUCT_MYSTR:%.*]], align 8
; CHECK-NEXT:    store i8 [[TMP0]], ptr [[U_PRIV]], align 1
; CHECK-NEXT:    [[U_PRIV_B4:%.*]] = getelementptr i8, ptr [[U_PRIV]], i64 4
; CHECK-NEXT:    store i32 [[TMP1]], ptr [[U_PRIV_B4]], align 4
; CHECK-NEXT:    [[TMP2:%.*]] = getelementptr [[STRUCT_MYSTR]], ptr [[U_PRIV]], i32 0, i32 1
; CHECK-NEXT:    store i32 99, ptr [[TMP2]], align 4
; CHECK-NEXT:    store i8 97, ptr [[U_PRIV]], align 8
; CHECK-NEXT:    [[L:%.*]] = load i8, ptr [[U_PRIV]], align 8
; CHECK-NEXT:    call void @use(i8 [[L]])
; CHECK-NEXT:    br label [[RETURN:%.*]]
; CHECK:       return:
; CHECK-NEXT:    ret void
;
entry:
  %0 = getelementptr %struct.MYstr, ptr %u, i32 0, i32 1 ; <ptr> [#uses=1]
  store i32 99, ptr %0, align 4
  %1 = getelementptr %struct.MYstr, ptr %u, i32 0, i32 0 ; <ptr> [#uses=1]
  store i8 97, ptr %1, align 4
  %l = load i8, ptr %1
  call void @use(i8 %l)
  br label %return

return:                                           ; preds = %entry
  ret void
}

define internal i32 @vfu2(ptr byval(%struct.MYstr) align 4 %u) nounwind readonly {
; CHECK: Function Attrs: mustprogress nofree norecurse nosync nounwind willreturn memory(none)
; CHECK-LABEL: define {{[^@]+}}@vfu2
; CHECK-SAME: (i8 [[TMP0:%.*]], i32 [[TMP1:%.*]]) #[[ATTR1:[0-9]+]] {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[U_PRIV:%.*]] = alloca [[STRUCT_MYSTR:%.*]], align 8
; CHECK-NEXT:    store i8 [[TMP0]], ptr [[U_PRIV]], align 1
; CHECK-NEXT:    [[U_PRIV_B4:%.*]] = getelementptr i8, ptr [[U_PRIV]], i64 4
; CHECK-NEXT:    store i32 [[TMP1]], ptr [[U_PRIV_B4]], align 4
; CHECK-NEXT:    [[TMP2:%.*]] = getelementptr [[STRUCT_MYSTR]], ptr [[U_PRIV]], i32 0, i32 1
; CHECK-NEXT:    [[TMP3:%.*]] = load i32, ptr [[TMP2]], align 4
; CHECK-NEXT:    [[TMP4:%.*]] = load i8, ptr [[U_PRIV]], align 8
; CHECK-NEXT:    [[TMP5:%.*]] = zext i8 [[TMP4]] to i32
; CHECK-NEXT:    [[TMP6:%.*]] = add i32 [[TMP5]], [[TMP3]]
; CHECK-NEXT:    ret i32 [[TMP6]]
;
entry:
  %0 = getelementptr %struct.MYstr, ptr %u, i32 0, i32 1 ; <ptr> [#uses=1]
  %1 = load i32, ptr %0
  %2 = getelementptr %struct.MYstr, ptr %u, i32 0, i32 0 ; <ptr> [#uses=1]
  %3 = load i8, ptr %2
  %4 = zext i8 %3 to i32
  %5 = add i32 %4, %1
  ret i32 %5
}

define i32 @unions() nounwind {
; TUNIT: Function Attrs: nounwind
; TUNIT-LABEL: define {{[^@]+}}@unions
; TUNIT-SAME: () #[[ATTR2:[0-9]+]] {
; TUNIT-NEXT:  entry:
; TUNIT-NEXT:    [[TMP0:%.*]] = load i8, ptr @mystr, align 8
; TUNIT-NEXT:    [[MYSTR_B41:%.*]] = getelementptr i8, ptr @mystr, i64 4
; TUNIT-NEXT:    [[TMP1:%.*]] = load i32, ptr [[MYSTR_B41]], align 8
; TUNIT-NEXT:    call void @vfu1(i8 [[TMP0]], i32 [[TMP1]]) #[[ATTR2]]
; TUNIT-NEXT:    [[TMP2:%.*]] = load i8, ptr @mystr, align 8
; TUNIT-NEXT:    [[MYSTR_B4:%.*]] = getelementptr i8, ptr @mystr, i64 4
; TUNIT-NEXT:    [[TMP3:%.*]] = load i32, ptr [[MYSTR_B4]], align 8
; TUNIT-NEXT:    [[RESULT:%.*]] = call i32 @vfu2(i8 [[TMP2]], i32 [[TMP3]]) #[[ATTR3:[0-9]+]]
; TUNIT-NEXT:    ret i32 [[RESULT]]
;
; CGSCC: Function Attrs: nounwind
; CGSCC-LABEL: define {{[^@]+}}@unions
; CGSCC-SAME: () #[[ATTR2:[0-9]+]] {
; CGSCC-NEXT:  entry:
; CGSCC-NEXT:    [[TMP0:%.*]] = load i8, ptr @mystr, align 8
; CGSCC-NEXT:    [[MYSTR_B4:%.*]] = getelementptr i8, ptr @mystr, i64 4
; CGSCC-NEXT:    [[TMP1:%.*]] = load i32, ptr [[MYSTR_B4]], align 8
; CGSCC-NEXT:    call void @vfu1(i8 [[TMP0]], i32 [[TMP1]]) #[[ATTR2]]
; CGSCC-NEXT:    [[TMP2:%.*]] = load i8, ptr @mystr, align 8
; CGSCC-NEXT:    [[MYSTR_B41:%.*]] = getelementptr i8, ptr @mystr, i64 4
; CGSCC-NEXT:    [[TMP3:%.*]] = load i32, ptr [[MYSTR_B41]], align 8
; CGSCC-NEXT:    [[RESULT:%.*]] = call i32 @vfu2(i8 [[TMP2]], i32 [[TMP3]]) #[[ATTR2]]
; CGSCC-NEXT:    ret i32 [[RESULT]]
;
entry:
  call void @vfu1(ptr byval(%struct.MYstr) align 4 @mystr) nounwind
  %result = call i32 @vfu2(ptr byval(%struct.MYstr) align 4 @mystr) nounwind
  ret i32 %result
}

define internal i32 @vfu2_v2(ptr byval(%struct.MYstr) align 4 %u) nounwind readonly {
; CHECK: Function Attrs: mustprogress nofree norecurse nosync nounwind willreturn memory(none)
; CHECK-LABEL: define {{[^@]+}}@vfu2_v2
; CHECK-SAME: (i8 [[TMP0:%.*]], i32 [[TMP1:%.*]]) #[[ATTR1]] {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[U_PRIV:%.*]] = alloca [[STRUCT_MYSTR:%.*]], align 8
; CHECK-NEXT:    store i8 [[TMP0]], ptr [[U_PRIV]], align 1
; CHECK-NEXT:    [[U_PRIV_B4:%.*]] = getelementptr i8, ptr [[U_PRIV]], i64 4
; CHECK-NEXT:    store i32 [[TMP1]], ptr [[U_PRIV_B4]], align 4
; CHECK-NEXT:    [[Z:%.*]] = getelementptr [[STRUCT_MYSTR]], ptr [[U_PRIV]], i32 0, i32 1
; CHECK-NEXT:    store i32 99, ptr [[Z]], align 4
; CHECK-NEXT:    [[TMP2:%.*]] = getelementptr [[STRUCT_MYSTR]], ptr [[U_PRIV]], i32 0, i32 1
; CHECK-NEXT:    [[TMP3:%.*]] = load i32, ptr [[TMP2]], align 4
; CHECK-NEXT:    [[TMP4:%.*]] = load i8, ptr [[U_PRIV]], align 8
; CHECK-NEXT:    [[TMP5:%.*]] = zext i8 [[TMP4]] to i32
; CHECK-NEXT:    [[TMP6:%.*]] = add i32 [[TMP5]], [[TMP3]]
; CHECK-NEXT:    ret i32 [[TMP6]]
;
entry:
  %z = getelementptr %struct.MYstr, ptr %u, i32 0, i32 1
  store i32 99, ptr %z, align 4
  %0 = getelementptr %struct.MYstr, ptr %u, i32 0, i32 1 ; <ptr> [#uses=1]
  %1 = load i32, ptr %0
  %2 = getelementptr %struct.MYstr, ptr %u, i32 0, i32 0 ; <ptr> [#uses=1]
  %3 = load i8, ptr %2
  %4 = zext i8 %3 to i32
  %5 = add i32 %4, %1
  ret i32 %5
}

define i32 @unions_v2() nounwind {
; TUNIT: Function Attrs: nounwind
; TUNIT-LABEL: define {{[^@]+}}@unions_v2
; TUNIT-SAME: () #[[ATTR2]] {
; TUNIT-NEXT:  entry:
; TUNIT-NEXT:    [[TMP0:%.*]] = load i8, ptr @mystr, align 8
; TUNIT-NEXT:    [[MYSTR_B4:%.*]] = getelementptr i8, ptr @mystr, i64 4
; TUNIT-NEXT:    [[TMP1:%.*]] = load i32, ptr [[MYSTR_B4]], align 8
; TUNIT-NEXT:    call void @vfu1(i8 [[TMP0]], i32 [[TMP1]]) #[[ATTR2]]
; TUNIT-NEXT:    [[TMP2:%.*]] = load i8, ptr @mystr, align 8
; TUNIT-NEXT:    [[MYSTR_B41:%.*]] = getelementptr i8, ptr @mystr, i64 4
; TUNIT-NEXT:    [[TMP3:%.*]] = load i32, ptr [[MYSTR_B41]], align 8
; TUNIT-NEXT:    [[RESULT:%.*]] = call i32 @vfu2_v2(i8 [[TMP2]], i32 [[TMP3]]) #[[ATTR3]]
; TUNIT-NEXT:    ret i32 [[RESULT]]
;
; CGSCC: Function Attrs: nounwind
; CGSCC-LABEL: define {{[^@]+}}@unions_v2
; CGSCC-SAME: () #[[ATTR2]] {
; CGSCC-NEXT:  entry:
; CGSCC-NEXT:    call void @vfu1(i8 noundef 0, i32 noundef 0) #[[ATTR2]]
; CGSCC-NEXT:    [[RESULT:%.*]] = call i32 @vfu2_v2(i8 noundef 0, i32 noundef 0) #[[ATTR2]]
; CGSCC-NEXT:    ret i32 [[RESULT]]
;
entry:
  call void @vfu1(ptr byval(%struct.MYstr) align 4 @mystr) nounwind
  %result = call i32 @vfu2_v2(ptr byval(%struct.MYstr) align 4 @mystr) nounwind
  ret i32 %result
}
;.
; TUNIT: attributes #[[ATTR0]] = { nounwind memory(readwrite, argmem: none) }
; TUNIT: attributes #[[ATTR1]] = { mustprogress nofree norecurse nosync nounwind willreturn memory(none) }
; TUNIT: attributes #[[ATTR2]] = { nounwind }
; TUNIT: attributes #[[ATTR3]] = { nounwind memory(read) }
;.
; CGSCC: attributes #[[ATTR0]] = { nounwind memory(readwrite, argmem: none) }
; CGSCC: attributes #[[ATTR1]] = { mustprogress nofree norecurse nosync nounwind willreturn memory(none) }
; CGSCC: attributes #[[ATTR2]] = { nounwind }
;.
