/* SPDX-License-Identifier: GPL-2.0-only */

#include <soc/gpio.h>

static const struct pad_config gpio_table[] = {
	/* ------- GPIO Group GPP_A ------- */
	PAD_CFG_NF(GPP_A0, NATIVE, DEEP, NF1),		// ESPI_IO0
	PAD_CFG_NF(GPP_A1, NATIVE, DEEP, NF1),		// ESPI_IO1
	PAD_CFG_NF(GPP_A2, NATIVE, DEEP, NF1),		// ESPI_IO2
	PAD_CFG_NF(GPP_A3, NATIVE, DEEP, NF1),		// ESPI_IO3
	PAD_CFG_NF(GPP_A4, NATIVE, DEEP, NF1),		// ESPI_CS0#
	PAD_CFG_NF(GPP_A5, NATIVE, DEEP, NF1),		// ESPI_CLK
	PAD_CFG_NF(GPP_A6, NATIVE, DEEP, NF1),		// ESPI_RESET#
	PAD_CFG_NF(GPP_A7, NATIVE, DEEP, NF1),		// ESPI_CS1#
	PAD_CFG_NF(GPP_A8, UP_20K, DEEP, NF1),		// ESPI_CS2#
	PAD_CFG_NF(GPP_A9, UP_20K, DEEP, NF1),		// ESPI_CS3#
	PAD_CFG_NF(GPP_A10, UP_20K, DEEP, NF1),		// ESPI_ALERT0#
	PAD_CFG_NF(GPP_A11, UP_20K, DEEP, NF1),		// ESPI_ALERT1#
	PAD_CFG_NF(GPP_A12, UP_20K, DEEP, NF1),		// ESPI_ALERT2#
	PAD_CFG_NF(GPP_A13, DN_20K, DEEP, NF1),		// ESPI_ALERT3#
	PAD_CFG_NF(GPP_A14, NATIVE, DEEP, NF1),		// Unknown

	/* ------- GPIO Group GPP_B ------- */
	PAD_CFG_GPO(GPP_B0, 1, PLTRST),			// GPO, some kind of VR?
	PAD_NC(GPP_B1, NONE),
	PAD_NC(GPP_B2, NONE),
	PAD_NC(GPP_B3, NONE),
	PAD_NC(GPP_B4, NONE),

	// We don't know the mapping of SRCCLKREQs because vendor refused to share schematics. Leave their configuration to the FSP.

	PAD_CFG_GPO(GPP_B11, 1, DEEP),			// GPO, some kind of VR?
	PAD_CFG_NF(GPP_B12, NONE, DEEP, NF1),		// SLP_S0#
	PAD_CFG_NF(GPP_B13, NONE, DEEP, NF1),		// PLT_RST#
	PAD_CFG_NF(GPP_B14, NONE, DEEP, NF1),		// SPK_BEEP
	PAD_NC(GPP_B15, NONE),
	PAD_NC(GPP_B16, NONE),
	PAD_NC(GPP_B17, NONE),
	PAD_NC(GPP_B18, NONE),
	PAD_NC(GPP_B19, NONE),
	PAD_NC(GPP_B20, NONE),
	PAD_NC(GPP_B21, NONE),
	PAD_NC(GPP_B22, NONE),
	PAD_CFG_GPO(GPP_B23, 1, PLTRST),		/* GPIO */

	/* ------- GPIO Group GPP_C ------- */
	PAD_CFG_NF(GPP_C0, NONE, PLTRST, NF1),		// SMBCLK
	PAD_CFG_NF(GPP_C1, NONE, PLTRST, NF1),		// SMBDATA
	PAD_CFG_NF(GPP_C2, NONE, PLTRST, NF1),		// SMBALERT#
	PAD_CFG_NF(GPP_C3, NONE, DEEP, NF3),		// I2C2_SDA
	PAD_CFG_NF(GPP_C4, NONE, DEEP, NF3),		// I2C2_SCL
	PAD_CFG_NF(GPP_C5, NONE, DEEP, NF1),		// SML0ALERT#
	PAD_CFG_NF(GPP_C3, NONE, DEEP, NF2),		// I2C3_SDA
	PAD_CFG_NF(GPP_C4, NONE, DEEP, NF2),		// I2C3_SCL
	PAD_NC(GPP_C8, NONE),
	PAD_NC(GPP_C9, NONE),
	PAD_NC(GPP_C10, NONE),
	PAD_NC(GPP_C11, NONE),
	PAD_CFG_GPO(GPP_C12, 1, PLTRST),		/* GPIO */
	PAD_CFG_GPO(GPP_C13, 1, PLTRST),		/* GPIO */
	PAD_CFG_GPO(GPP_C14, 1, PLTRST),		/* GPIO */
	PAD_CFG_GPO(GPP_C15, 1, PLTRST),		/* GPIO */
	PAD_CFG_NF(GPP_C16, NONE, DEEP, NF1),		// I2C0_SDA
	PAD_CFG_NF(GPP_C17, NONE, DEEP, NF1),		// I2C0_SCL
	PAD_CFG_NF(GPP_C18, NONE, DEEP, NF1),		// I2C1_SDA
	PAD_CFG_NF(GPP_C19, NONE, DEEP, NF1),		// I2C1_SCL
	PAD_NC(GPP_C20, NONE),
	PAD_NC(GPP_C21, NONE),
	PAD_NC(GPP_C22, NONE),
	PAD_NC(GPP_C23, NONE),

	/* ------- GPIO Group GPP_D ------- */
	PAD_NC(GPP_D0, NONE),
	PAD_NC(GPP_D1, NONE),
	PAD_NC(GPP_D2, NONE),
	PAD_NC(GPP_D3, NONE),
	PAD_CFG_NF(GPP_D4, NONE, RSMRST, NF1),		// SML1CLK
	PAD_CFG_NF(GPP_D5, NONE, DEEP, NF2),		// CNV_RF_RESET#
	PAD_CFG_NF(GPP_D6, NONE, DEEP, NF2),		// MODEM_CLKREQ
	PAD_NC(GPP_D7, NONE),
	PAD_NC(GPP_D8, NONE),
	PAD_CFG_NF(GPP_D9, NONE, DEEP, NF1),		// SML0CLK
	PAD_CFG_NF(GPP_D10, NONE, DEEP, NF1),		// SML0DATA
	PAD_CFG_GPO(GPP_D11, 1, PLTRST),		/* GPIO */
	PAD_CFG_GPO(GPP_D12, 1, PLTRST),		/* GPIO */
	PAD_NC(GPP_D13, NONE),
	PAD_NC(GPP_D14, NONE),
	PAD_CFG_NF(GPP_D15, NONE, RSMRST, NF1),		// SML1DATA
	PAD_NC(GPP_D16, NONE),
	PAD_NC(GPP_D17, NONE),
	PAD_NC(GPP_D18, NONE),
	PAD_NC(GPP_D19, NONE),
	PAD_NC(GPP_D20, NONE),
	PAD_NC(GPP_D21, NONE),
	PAD_NC(GPP_D22, NONE),
	PAD_NC(GPP_D23, NONE),

	/* ------- GPIO Group GPP_E ------- */
	PAD_CFG_NF(GPP_E0, NONE, PLTRST, NF1),		// SATAXPCIE0
	PAD_CFG_NF(GPP_E1, NONE, PLTRST, NF1),		// SATAXPCIE1
	PAD_CFG_GPO(GPP_E2, 1, PLTRST),			/* GPIO */
	PAD_CFG_GPO(GPP_E3, 1, PLTRST),			/* GPIO */
	PAD_CFG_NF(GPP_E4, NONE, PWROK, NF1),		// SATA_DEVSLP0
	PAD_CFG_NF(GPP_E5, NONE, PWROK, NF1),		// SATA_DEVSLP1
	PAD_CFG_GPO(GPP_E6, 1, PLTRST),			/* GPIO */
	PAD_NC(GPP_E7, NONE),
	PAD_CFG_NF(GPP_E8, NONE, DEEP, NF1),		// SATALED#
	PAD_CFG_NF(GPP_E9, NONE, PLTRST, NF1),		// USB_OC0#
	PAD_CFG_NF(GPP_E10, NONE, PLTRST, NF1),		// USB_OC1#
	PAD_CFG_NF(GPP_E11, NONE, PLTRST, NF1),		// USB_OC2#
	PAD_CFG_NF(GPP_E12, NONE, PLTRST, NF1),		// USB_OC3#

	/* ------- GPIO Group GPP_F ------- */
	PAD_CFG_NF(GPP_F0, NONE, PLTRST, NF1),		// SATAXPCIE3
	PAD_CFG_NF(GPP_F1, NONE, PLTRST, NF1),		// SATAXPCIE4
	PAD_CFG_NF(GPP_F2, NONE, PLTRST, NF1),		// SATAXPCIE5
	PAD_CFG_GPO(GPP_F3, 0, PLTRST),			/* GPIO */
	PAD_CFG_GPO(GPP_F4, 1, PLTRST),			/* GPIO */
	PAD_CFG_GPO(GPP_F5, 1, PLTRST),			/* GPIO */
	PAD_NC(GPP_F6, NONE),
	PAD_CFG_GPO(GPP_F7, 1, PLTRST),			/* GPIO */
	PAD_NC(GPP_F8, NONE),
	PAD_CFG_GPO(GPP_F9, 1, PLTRST),			/* GPIO */
	PAD_NC(GPP_F10, NONE),
	PAD_CFG_GPO(GPP_F11, 1, PLTRST),		/* GPIO */
	PAD_CFG_GPO(GPP_F12, 1, DEEP),			/* GPIO */
	PAD_CFG_GPO(GPP_F13, 1, PLTRST),		/* GPIO */
	PAD_CFG_NF(GPP_F14, NONE, PLTRST, NF1),		// PS_ON#
	PAD_CFG_GPI_TRIG_OWN(GPP_F15, NONE, DEEP, OFF, ACPI),	/* GPIO */
	PAD_CFG_GPO(GPP_F16, 1, PLTRST),		/* GPIO */
	PAD_NC(GPP_F17, NONE),
	PAD_CFG_GPO(GPP_F18, 1, PLTRST),		/* GPIO */
	PAD_NC(GPP_F19, NONE),
	PAD_NC(GPP_F20, NONE),
	PAD_NC(GPP_F21, NONE),
	PAD_NC(GPP_F22, NONE),
	PAD_CFG_GPO(GPP_F23, 1, PLTRST),		/* GPIO */

	/* ------- GPIO Group GPP_G ------- */
	PAD_NC(GPP_G0, NONE),
	PAD_CFG_GPO(GPP_G1, 0, DEEP),	/* GPIO */
	PAD_CFG_GPO(GPP_G2, 0, PLTRST),	/* GPIO */
	PAD_CFG_GPO(GPP_G3, 1, PLTRST),	/* GPIO */
	PAD_CFG_GPO(GPP_G4, 1, PLTRST),	/* GPIO */
	PAD_CFG_NF(GPP_G5, NONE, PLTRST, NF1),		// SLP_DRAM#
	PAD_CFG_GPO(GPP_G6, 1, PLTRST),	/* GPIO */
	PAD_CFG_GPO(GPP_G7, 1, PLTRST),	/* GPIO */
	PAD_NC(GPP_G8, NONE),
	PAD_NC(GPP_G9, NONE),
	PAD_NC(GPP_G10, NONE),
	PAD_NC(GPP_G11, NONE),
	PAD_CFG_NF(GPP_G12, NATIVE, DEEP, NF1),		// DDP1_CTRLCLK
	PAD_CFG_NF(GPP_G13, NATIVE, DEEP, NF1),		// DDP1_CTRLDATA
	PAD_CFG_NF(GPP_G14, NATIVE, DEEP, NF1),		// DDP2_CTRLCLK
	PAD_CFG_NF(GPP_G15, NATIVE, DEEP, NF1),		// DDP2_CTRLDATA

	/* ------- GPIO Group GPP_H ------- */

	// We don't know the mapping of SRCCLKREQs because vendor refused to share schematics. Leave their configuration to the FSP.

	PAD_CFG_GPO(GPP_H10, 1, PLTRST),		// GPIO */
	PAD_NC(GPP_H11, NONE),
	PAD_CFG_GPO(GPP_H12, 1, PLTRST),		/* GPIO */
	PAD_CFG_GPO(GPP_H13, 1, PLTRST),		/* GPIO */
	PAD_CFG_GPO(GPP_H14, 0, PLTRST),		/* GPIO */
	PAD_CFG_GPO(GPP_H15, 1, PLTRST),		/* GPIO */
	PAD_CFG_GPO(GPP_H16, 1, PLTRST),		/* GPIO */
	PAD_CFG_GPO(GPP_H17, 1, PLTRST),		/* GPIO */
	PAD_CFG_GPO(GPP_H18, 0, PLTRST),		/* GPIO */
	PAD_NC(GPP_H19, NONE),
	PAD_NC(GPP_H20, NONE),
	PAD_NC(GPP_H21, NONE),
	PAD_NC(GPP_H22, NONE),
	PAD_CFG_GPO(GPP_H23, 1, PLTRST),		/* GPIO */

	/* ------- GPIO Group GPP_I ------- */
	PAD_CFG_NF(GPP_I0, NONE, RSMRST, NF1),		// PMCALERT#
	PAD_CFG_NF(GPP_I1, NONE, DEEP, NF1),		// DDSP_HPD1
	PAD_CFG_NF(GPP_I2, NONE, DEEP, NF1),		// DDSP_HPD2
	PAD_NC(GPP_I3, NONE),
	PAD_NC(GPP_I4, NONE),
	PAD_CFG_NF(GPP_I5, NATIVE, DEEP, NF1),		// DDPB_CTRLCLK
	PAD_CFG_NF(GPP_I6, NATIVE, DEEP, NF1),		// DDPB_CTRLDATA
	PAD_CFG_NF(GPP_I7, NATIVE, DEEP, NF1),		// DDPC_CTRLCLK
	PAD_CFG_NF(GPP_I8, NATIVE, DEEP, NF1),		// DDPC_CTRLDATA
	PAD_CFG_GPO(GPP_I9, 1, PLTRST),			/* GPIO */
	PAD_CFG_GPO(GPP_I10, 1, PLTRST),		/* GPIO */
	PAD_CFG_NF(GPP_I11, NONE, DEEP, NF2),		// I2C4_SDA
	PAD_CFG_NF(GPP_I12, NONE, DEEP, NF2),		// I2C4_SCL
	PAD_CFG_NF(GPP_I13, NONE, DEEP, NF1),		// USB_OC6#
	PAD_CFG_NF(GPP_I14, NONE, DEEP, NF2),		// I2C5_SCL

	/* ------- GPIO Group GPP_J ------- */
	PAD_CFG_GPO(GPP_J0, 1, PLTRST),			/* GPIO */
	PAD_CFG_NF(GPP_J1, NONE, DEEP, NF1),		// CPU_C10_GATE#
	PAD_CFG_NF(GPP_J2, NONE, DEEP, NF1),		// CNVI_BRI_DT
	PAD_CFG_NF(GPP_J3, UP_20K, DEEP, NF1),		// CNVI_BRI_RSP
	PAD_CFG_NF(GPP_J4, NONE, DEEP, NF1),		// CNVI_RGI_DT
	PAD_CFG_NF(GPP_J5, UP_20K, DEEP, NF1),		// CNVI_RGI_RSP
	PAD_CFG_NF(GPP_J6, NONE, DEEP, NF1),		// CNVI_MFUART2_RXD
	PAD_CFG_NF(GPP_J7, NONE, DEEP, NF1),		// CNVI_MFUART2_TXD
	PAD_CFG_GPO(GPP_J8, 1, PLTRST),			/* GPIO */
	PAD_CFG_GPO(GPP_J9, 1, PLTRST),			/* GPIO */

	/* ------- GPIO Group GPP_K ------- */
	PAD_CFG_GPO(GPP_K0, 1, PLTRST),			/* GPIO */
	PAD_CFG_GPO(GPP_K1, 1, PLTRST),			/* GPIO */
	PAD_CFG_GPO(GPP_K2, 1, PLTRST),			/* GPIO */
	PAD_CFG_GPO(GPP_K3, 1, PLTRST),			/* GPIO */
	PAD_CFG_GPO(GPP_K4, 1, PLTRST),			/* GPIO */
	PAD_CFG_GPO(GPP_K5, 1, PLTRST),			/* GPIO */
	PAD_NC(GPP_K6, NONE),
	PAD_CFG_NF(GPP_K7, NONE, DEEP, NF1),		// DDSP_HPDB
	PAD_CFG_NF(GPP_K8, NONE, DEEP, NF1),		// CORE_VID0
	PAD_CFG_NF(GPP_K9, NONE, DEEP, NF1),		// CORE_VID1
	PAD_CFG_NF(GPP_K10, NONE, DEEP, NF1),		// DDSP_HPDC
	PAD_NC(GPP_K11, NONE),

	/* ------- GPIO Group GPP_R ------- */
	PAD_CFG_NF(GPP_R0, NONE, DEEP, NF1),		// HDA_BCLK
	PAD_CFG_NF(GPP_R1, NATIVE, DEEP, NF1),		// HDA_SYNC
	PAD_CFG_NF(GPP_R2, NATIVE, DEEP, NF1),		// HDA_SDO
	PAD_CFG_NF(GPP_R3, NATIVE, DEEP, NF1),		// HDA_SDI
	PAD_CFG_NF(GPP_R4, NONE, DEEP, NF1),		// HDA_RST#
	// Using HDA instead of SOF, disable I2S
	PAD_NC(GPP_R5, NONE),
	PAD_NC(GPP_R6, NONE),
	PAD_NC(GPP_R7, NONE),
	PAD_NC(GPP_R8, NONE),
	PAD_CFG_NF(GPP_R9, NATIVE, DEEP, NF1),		// PCIE_LNK_DOWN
	PAD_CFG_NF(GPP_R10, NATIVE, DEEP, NF1),		// ISH_UART0_RTS#
	PAD_CFG_NF(GPP_R11, NATIVE, DEEP, NF1),		// SX_EXIT_HOLDOFF#
	PAD_CFG_NF(GPP_R12, NATIVE, DEEP, NF1),		// CLKOUT_48
	PAD_CFG_NF(GPP_R13, NATIVE, DEEP, NF1),		// ISH_GP7
	PAD_NC(GPP_R14, NONE),
	PAD_NC(GPP_R15, NONE),
	PAD_NC(GPP_R16, NONE),
	PAD_NC(GPP_R17, NONE),
	PAD_CFG_GPO(GPP_R18, 1, PLTRST),		// GPO, some kind of VR?
	PAD_NC(GPP_R19, NONE),

	/* ------- GPIO Group GPP_S (SoundWire - unused) ------- */
	PAD_NC(GPP_S0, NONE),
	PAD_NC(GPP_S1, NONE),
	PAD_NC(GPP_S2, NONE),
	PAD_NC(GPP_S3, NONE),
	PAD_NC(GPP_S4, NONE),
	PAD_NC(GPP_S5, NONE),
	PAD_NC(GPP_S6, NONE),
	PAD_NC(GPP_S7, NONE),

	/* ------- GPIO Group GPD ------- */
	PAD_CFG_NF(GPD0, UP_20K, PWROK, NF1),		// BATLOW#
	PAD_CFG_NF(GPD1, NATIVE, PWROK, NF1),		// ACPRESENT
	PAD_CFG_NF(GPD2, NATIVE, PLTRST, NF1),		// LAN_WAKE#
	PAD_CFG_NF(GPD3, UP_20K, PLTRST, NF1),		// PWRBTN#
	PAD_CFG_NF(GPD4, NONE, PLTRST, NF1),		// SLP_S3#
	PAD_CFG_NF(GPD5, NONE, PLTRST, NF1),		// SLP_S4#
	PAD_CFG_NF(GPD6, NONE, PLTRST, NF1),		// SLP_A#
	PAD_CFG_GPO(GPD7, 1, PLTRST),			// GPIO
	PAD_CFG_NF(GPD8, NONE, PLTRST, NF1),		// SUSCLK
	PAD_CFG_NF(GPD9, NONE, PLTRST, NF1),		// SLP_WLAN#
	PAD_CFG_NF(GPD10, NONE, PLTRST, NF1),		// SLP_S5#
	PAD_CFG_NF(GPD11, NONE, PLTRST, NF1),		// LANPHYPC
	PAD_NC(GPD12, NONE),				// GPIO
};
