---
myst:
  html_meta:
    keywords: LaTeX, domaines spécialisés, mathématiques, structures, 
              théorème, mise en page de théorème, proposition, axiome, lemme,
              numérotation  
---

# Comment mettre en page des théorèmes ?

Pour présenter des théorèmes, lemmes, propositions ou bien encore axiomes,
il existe plusieurs possibilités, présentées ici.

Si vous cherchez à ajouter un carré en fin de texte du théorème, vous pouvez
consulter la question 
"[](/4_domaines_specialises/mathematiques/symboles/symbole_cqfd)".


## Avec les commandes de base

LaTeX dispose de la commande `\newtheorem` qui existe sous deux formes :

```{noedit}
\newtheorem{⟨nom⟩}[⟨compteur⟩]{⟨texte⟩}[⟨section⟩]
\newtheorem{⟨nom⟩}[⟨compteur⟩]{⟨texte⟩}
```

Dans cette définition :

- `⟨nom⟩` est une clé pour identifier le théorème ;
- `⟨texte⟩` le titre du théorème qui sera imprimé ;
- `⟨compteur⟩` permet de référencer un autre type de théorème en suivant 
  la numérotation des théorèmes désignés dont le `⟨nom⟩` est `⟨compteur⟩`. 
  La deuxième forme est donc adaptée pour créer des éléments qui incrémentent ;
- `⟨section⟩` permet de préciser le niveau de numérotation voulu 
  pour la numérotation des théorèmes (cela peut donc valoir `chapter`, 
  `section`, `subsection`).

En voici un exemple :

```
\documentclass{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \pagestyle{empty}           % N'affiche pas de numéro de page

  \newtheorem{th-imp}{Théorème important}[section]
  \newtheorem{th-u}{Théorème}[subsection]

\begin{document}
\section{Introduction}
\begin{th-imp} \label{th-AA}
  BLA BLA
\end{th-imp}
\subsection{Bases}

\begin{th-u} \label{th-aaa}
  bla bla bla
\end{th-u}

\begin{th-u}
  bla bla
\end{th-u}

\section{Conclusion}

Le théorème important~\ref{th-AA} est à apprendre par c\oe{}ur
tandis que le théorème~\ref{th-aaa} peut être utile.
\end{document}
```


## Avec l'extension <ctanpkg:ntheorem>

L'extension <ctanpkg:ntheorem> peut générer une liste des théorèmes 
de la même manière que `\listoffigures`, est compatible 
avec <ctanpkg:mathtools> (et donc <ctanpkg:amsmath>), permet d'ajouter 
des symboles à la fin d'un théorème (carré, q.e.d.), et permet également
la référence à d'autres théorèmes. Pour plus de précisions, vous pouvez
consulter la [documentation](texdoc:ntheorem) de l'extension. Voici un exemple
d'utilisation.

```
\documentclass{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \pagestyle{empty}           % N'affiche pas de numéro de page
  \usepackage[thmmarks]{ntheorem}

  {\theoremstyle{changebreak}
  \theoremindent0.5cm
  \theoremnumbering{greek}
  \newtheorem{Lemma}{Lemme}}

  {\theoremheaderfont{\normalfont%
    \bfseries}
  \theorembodyfont{\slshape}
  \theoremsymbol{\ensuremath{%
    \diamondsuit}}
  \theoremseparator{:}
  \newtheorem{Theorem}{Théorème}}

  {\theoremheaderfont{\sc}%
    \theorembodyfont{\upshape}
  \theoremstyle{nonumberplain}
  \theoremseparator{}
  \theoremsymbol{\rule{1ex}{1ex}}
  \newtheorem{Proof}{Preuve}}

\begin{document}
\begin{Theorem}[Théorème complexe]
  Voici l'énoncé de mon théorème.

  \begin{Lemma}[Equation]
    \label{lem=equ}
     Un lemme important :
    \begin{equation}
      0+0=\mbox{la t\^ete à toto}
    \end{equation}
  \end{Lemma}

  \begin{Proof}[de rien]
    D'après le lemme $\alpha$, le théorème est évident.
  \end{Proof}
  Fin du théorème.
\end{Theorem}
\end{document}
```


## Avec l'extension <ctanpkg:theorem>

L'extension <ctanpkg:theorem> augmente les possibilités de présentation 
de l'environnement pour les théorèmes que propose LaTeX par défaut.


## Avec l'extension <ctanpkg:mathtools> 

L'extension <ctanpkg:mathtools> (ou <ctanpkg:amsmath>) définit 
l'environnement `proof` insérant un carré.

:::{todo} Présenter <ctanpkg:amsthm>.
:::


## Avec l'extension <ctanpkg:shadethm>

L'extension <ctanpkg:shadethm> permet d'écrire des théorèmes sur fond ombré.

:::{todo} Faire un exemple.
:::


## Avec l'extension <ctanpkg:nccthm>

L'extension <ctanpkg:nccthm> permet de faire à peu près la même chose 
que <ctanpkg:ntheorem>. Il dispose de compteurs dynamiques, 
de différents styles, de symboles de fin de preuve, etc. Vous pouvez vous
reporter à la [documentation](texdoc:nccthm) de l'extension 
pour plus d'informations.


## Récapitulatif

| Extension                               | <ctanpkg:amsthm> | <ctanpkg:theorem> | <ctanpkg:ntheorem> |
|-----------------------------------------|------------------|-------------------|--------------------|
| Retour à la ligne après le titre        | x                | x                 | x                  |
| Pas de numérotation d'un théorème       | x                |                   | x                  |
| Position du numéro du théorème          |                  | x                 | x                  |
| Style de la numérotation                |                  |                   | x                  |
| Ponctuation après le titre (:, ., etc.) | x                |                   | x                  |
| Police du titre ou du corps             | x                | x                 | x                  |
| Indentation du titre                    | x                |                   |                    |
| Espace vertical autour du théorème      | x                | x                 | x                  |
| Symbole de fin de preuve                | x                |                   | x                  |

:::{todo} *Revoir le tableau du fait des autres extensions évoquées.*
:::