#! /bin/sh

if [ "${AUTOPKGTEST_TMP}" = "" ]
then
    AUTOPKGTEST_TMP=$(mktemp -d /tmp/${pkg}-test.XXXXXX)
    # Double quote below to expand the temporary directory variable now
    # versus later is on purpose.
    # shellcheck disable=SC2064
    trap "rm -rf ${AUTOPKGTEST_TMP}" 0 INT QUIT ABRT PIPE TERM
fi
cd "$AUTOPKGTEST_TMP"

cat > test-rocm-core-path.cpp << END
#include <cstdint>
#include <cstdio>
#include <cinttypes>
#include <cstdlib>

#include <rocm-core/rocm_getpath.h>

int main()
{
    char *installPath=NULL;
    unsigned int installPathLen = 0;
    PathErrors_t installStatus;

    installStatus = getROCmInstallPath( &installPath, &installPathLen );

    if(installStatus !=PathSuccess )
    {  // error occured
        free(installPath); //caller must free allocated memory after usage.
        std::printf("ERROR: recieved return code from getROCmInstallPath: %d\n", installStatus);
        return 255;
    }

    std::printf("SUCCESS: ROCm install path from rocm-core detected as: %s\n", installPath);
    free(installPath); //caller must free allocated memory after usage.
    return 0;

}
END

echo '$ cat test-rocm-core-path.cpp'
cat test-rocm-core-path.cpp
echo "$ g++ -o test-rocm-core-path test-rocm-core-path.cpp -lrocm-core"
g++ -o test-rocm-core-path test-rocm-core-path.cpp -lrocm-core

./test-rocm-core-path
exit $?
