# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from azure.identity import DefaultAzureCredential
from azure.mgmt.testbase import TestBase

"""
# PREREQUISITES
    pip install azure-identity
    pip install azure-mgmt-testbase
# USAGE
    python customer_event_create.py

    Before run the sample, please set the values of the client ID, tenant ID and client secret
    of the AAD application as environment variables: AZURE_CLIENT_ID, AZURE_TENANT_ID,
    AZURE_CLIENT_SECRET. For more info about how to get the value, please see:
    https://docs.microsoft.com/azure/active-directory/develop/howto-create-service-principal-portal
"""


def main():
    client = TestBase(
        credential=DefaultAzureCredential(),
        subscription_id="subscription-id",
    )

    response = client.customer_events.begin_create(
        resource_group_name="contoso-rg1",
        test_base_account_name="contoso-testBaseAccount1",
        customer_event_name="WeeklySummary",
        parameters={
            "properties": {
                "eventName": "WeeklySummary",
                "receivers": [
                    {
                        "receiverType": "UserObjects",
                        "receiverValue": {
                            "userObjectReceiverValue": {"userObjectIds": ["245245245245325", "365365365363565"]}
                        },
                    },
                    {
                        "receiverType": "DistributionGroup",
                        "receiverValue": {
                            "distributionGroupListReceiverValue": {"distributionGroups": ["test@microsoft.com"]}
                        },
                    },
                ],
            }
        },
    ).result()
    print(response)


# x-ms-original-file: specification/testbase/resource-manager/Microsoft.TestBase/preview/2022-04-01-preview/examples/CustomerEventCreate.json
if __name__ == "__main__":
    main()
