# This file is licensed under the Apache License v2.0 with LLVM Exceptions.
# See https://llvm.org/LICENSE.txt for license information.
# SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception

"""Common configuration for LLDB plugins."""

load("//:vars.bzl", "CMAKE_CXX_STANDARD")

DEFAULT_PLUGINS = [
    "ABIAArch64",
    "ABIARM",
    "ABIHexagon",
    "ABIMips",
    "ABIMSP430",
    "ABIPowerPC",
    "ABIRISCV",
    "ABISystemZ",
    "ABIX86",
    "AppleObjCRuntime",
    "ArchitectureAArch64",
    "ArchitectureArm",
    "ArchitectureMips",
    "ArchitecturePPC64",
    "ClangREPL",
    "CPlusPlusLanguage",
    "CXXItaniumABI",
    "DisassemblerLLVMC",
    "DynamicLoaderDarwinKernel",
    "DynamicLoaderHexagonDYLD",
    "DynamicLoaderMacOSXDYLD",
    "DynamicLoaderPosixDYLD",
    "DynamicLoaderStatic",
    "DynamicLoaderWasmDYLD",
    "DynamicLoaderWindowsDYLD",
    "GNUstepObjCRuntime",
    "InstructionARM",
    "InstructionARM64",
    "InstructionLoongArch",
    "InstructionMIPS",
    "InstructionMIPS64",
    "InstructionPPC64",
    "InstructionRISCV",
    "InstrumentationRuntimeASan",
    "InstrumentationRuntimeASanLibsanitizers",
    "InstrumentationRuntimeMainThreadChecker",
    "InstrumentationRuntimeTSan",
    "InstrumentationRuntimeUBSan",
    "JITLoaderGDB",
    "MemoryHistoryASan",
    "ObjCLanguage",
    "ObjCPlusPlusLanguage",
    "ObjectContainerBSDArchive",
    "ObjectContainerMachOArchive",
    "ObjectContainerMachOFileset",
    "ObjectFileBreakpad",
    "ObjectFileCOFF",
    "ObjectFileELF",
    "ObjectFileJSON",
    "ObjectFileMachO",
    "ObjectFileMinidump",
    "ObjectFilePDB",
    "ObjectFilePECOFF",
    "ObjectFilePlaceholder",
    "ObjectFileWasm",
    "PlatformAndroid",
    "PlatformGDB",
    "PlatformLinux",
    "PlatformMacOSX",
    "PlatformQemuUser",
    "PlatformWindows",
    "ProcessElfCore",
    "ProcessMachCore",
    "ProcessMinidump",
    "RegisterTypeBuilderClang",
    "ScriptedProcess",
    "StructuredDataDarwinLog",
    "SymbolFileBreakpad",
    "SymbolFileCTF",
    "SymbolFileDWARF",
    "SymbolFileJSON",
    "SymbolFilePDB",
    "SymbolFileSymtab",
    "SymbolLocatorDebuginfod",
    "SymbolLocatorDefault",
    "SymbolVendorELF",
    "SymbolVendorPECOFF",
    "SymbolVendorWasm",
    "SystemRuntimeMacOSX",
    "TraceExporterCTF",
    "TypeSystemClang",
    "UnwindAssemblyInstEmulation",
    "UnwindAssemblyX86",
]

DEFAULT_SCRIPT_PLUGINS = [
    "ScriptInterpreterNone",
]

OBJCPP_COPTS = [
    "-std=c++{}".format(CMAKE_CXX_STANDARD),
    "-fno-objc-exceptions",
    "-Wno-shorten-64-to-32",
]
