/*
 *  $Id: xyz.c 28135 2025-06-24 14:51:47Z yeti-dn $
 *  Copyright (C) 2025 David Nečas (Yeti).
 *  E-mail: yeti@gwyddion.net.
 *
 *  This program is free software; you can redistribute it and/or modify it under the terms of the GNU General Public
 *  License as published by the Free Software Foundation; either version 2 of the License, or (at your option) any
 *  later version.
 *
 *  This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied
 *  warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 *  details.
 *
 *  You should have received a copy of the GNU General Public License along with this program; if not, write to the
 *  Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include "tests/testlibgwy.h"

static void
serialize_and_back(GwyXYZ xyz)
{
    GwyXYZ *copy = serialize_boxed_and_back(&xyz, GWY_TYPE_XYZ, TRUE);
    g_assert_cmpfloat(xyz.x, ==, copy->x);
    g_assert_cmpfloat(xyz.y, ==, copy->y);
    g_assert_cmpfloat(xyz.z, ==, copy->z);
    g_boxed_free(GWY_TYPE_XYZ, copy);
}

void
test_xyz_boxed_serialization(void)
{
    serialize_and_back((GwyXYZ){ G_PI, -1, 2.2 });
    serialize_and_back((GwyXYZ){ 0.0, 7.2, -13.1 });
    serialize_and_back((GwyXYZ){ 31.125, 0.0, 6.2e44 });
    serialize_and_back((GwyXYZ){ 10.1, 10.001, 0.0 });
    serialize_and_back((GwyXYZ){ 0.0, 0.0, 0.0 });
}

void
test_xyz_boxed_equal(void)
{
    GwyXYZ xyz1 = { 3.6, 1e14, -12.0 };
    GwyXYZ xyz2 = { 3.6, 3.6, -12.0 };
    GwyXYZ xyz3 = { 1e14, 1e14, -12.0 };
    GwyXYZ xyz4 = { 3.6, -12.0, -12.0 };
    GwyXYZ xyz5 = { -12.0, 1e14, -12.0 };
    GwyXYZ xyz6 = { 3.6, 1e14, -12.0 };

    g_assert_false(gwy_serializable_boxed_equal(GWY_TYPE_XYZ, &xyz1, &xyz2));
    g_assert_false(gwy_serializable_boxed_equal(GWY_TYPE_XYZ, &xyz1, &xyz3));
    g_assert_false(gwy_serializable_boxed_equal(GWY_TYPE_XYZ, &xyz1, &xyz4));
    g_assert_false(gwy_serializable_boxed_equal(GWY_TYPE_XYZ, &xyz1, &xyz5));
    g_assert_false(gwy_serializable_boxed_equal(GWY_TYPE_XYZ, &xyz2, &xyz3));
    g_assert_false(gwy_serializable_boxed_equal(GWY_TYPE_XYZ, &xyz2, &xyz4));
    g_assert_false(gwy_serializable_boxed_equal(GWY_TYPE_XYZ, &xyz2, &xyz5));
    g_assert_false(gwy_serializable_boxed_equal(GWY_TYPE_XYZ, &xyz3, &xyz4));
    g_assert_false(gwy_serializable_boxed_equal(GWY_TYPE_XYZ, &xyz3, &xyz5));
    g_assert_false(gwy_serializable_boxed_equal(GWY_TYPE_XYZ, &xyz4, &xyz5));
    g_assert_true(gwy_serializable_boxed_equal(GWY_TYPE_XYZ, &xyz1, &xyz6));
}

void
test_xyz_boxed_assign(void)
{
    GwyXYZ xyz1 = { 3.6, 1e14, -12.0 };
    GwyXYZ xyz2 = { 7.7, 1e-6, 105.5 };
    GwyXYZ xyz3, xyz0;

    xyz0 = xyz1;
    gwy_serializable_boxed_assign(GWY_TYPE_XYZ, &xyz3, &xyz1);
    g_assert_cmpfloat(xyz1.x, ==, xyz0.x);
    g_assert_cmpfloat(xyz1.y, ==, xyz0.y);
    g_assert_cmpfloat(xyz1.z, ==, xyz0.z);
    g_assert_cmpfloat(xyz3.x, ==, xyz1.x);
    g_assert_cmpfloat(xyz3.y, ==, xyz1.y);
    g_assert_cmpfloat(xyz3.z, ==, xyz1.z);

    xyz0 = xyz2;
    gwy_serializable_boxed_assign(GWY_TYPE_XYZ, &xyz3, &xyz2);
    g_assert_cmpfloat(xyz2.x, ==, xyz0.x);
    g_assert_cmpfloat(xyz2.y, ==, xyz0.y);
    g_assert_cmpfloat(xyz2.z, ==, xyz0.z);
    g_assert_cmpfloat(xyz3.x, ==, xyz2.x);
    g_assert_cmpfloat(xyz3.y, ==, xyz2.y);
    g_assert_cmpfloat(xyz3.z, ==, xyz2.z);
}

/* vim: set cin columns=120 tw=118 et ts=4 sw=4 cino=>1s,e0,n0,f0,{0,}0,^0,\:1s,=0,g1s,h0,t0,+1s,c3,(0,u0 : */
