"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.CffCidCharSetSource = exports.CffGlyphNameCharSetSource = void 0;
const errors_1 = require("@ot-builder/errors");
class CffGlyphNameCharSetSource {
    constructor(ctx, gOrd) {
        this.ctx = ctx;
        this.gOrd = gOrd;
    }
    getMappingList() {
        if (!this.ctx.strings)
            throw errors_1.Errors.Cff.ShouldHaveStrings();
        const results = [];
        for (let gid = 0; gid < this.gOrd.length; gid++) {
            results[gid] = this.ctx.strings.push(this.gOrd.at(gid).name || `.OTBuilder!GID${gid}`);
        }
        return results;
    }
}
exports.CffGlyphNameCharSetSource = CffGlyphNameCharSetSource;
class CffCidCharSetSource {
    constructor(ctx, gOrd, cidMap) {
        this.ctx = ctx;
        this.gOrd = gOrd;
        this.cidMap = cidMap;
    }
    getMappingList() {
        const results = [];
        if (!this.cidMap) {
            for (let gid = 0; gid < this.gOrd.length; gid++) {
                results.push(gid);
            }
        }
        else {
            const revMap = new Map();
            for (const [cid, glyph] of this.cidMap)
                revMap.set(glyph, cid);
            for (let gid = 0; gid < this.gOrd.length; gid++) {
                const cid = revMap.get(this.gOrd.at(gid));
                if (cid === undefined)
                    throw errors_1.Errors.GlyphNotFound(`CID mapping`);
                results[gid] = cid;
            }
        }
        return results;
    }
}
exports.CffCidCharSetSource = CffCidCharSetSource;
//# sourceMappingURL=glyph-data-source.js.map