#pragma once

#include <cstdint>  // std::uint64_t

#include "libipc/imp/export.h"
#include "libipc/def.h"

namespace ipc {
namespace sync {

class LIBIPC_EXPORT semaphore {
    semaphore(semaphore const &) = delete;
    semaphore &operator=(semaphore const &) = delete;

public:
    semaphore();
    explicit semaphore(char const *name, std::uint32_t count = 0);
    ~semaphore();

    void const *native() const noexcept;
    void *native() noexcept;

    bool valid() const noexcept;

    bool open(char const *name, std::uint32_t count = 0) noexcept;
    void close() noexcept;

    void clear() noexcept;
    static void clear_storage(char const * name) noexcept;

    bool wait(std::uint64_t tm = ipc::invalid_value) noexcept;
    bool post(std::uint32_t count = 1) noexcept;

private:
    class semaphore_;
    semaphore_* p_;
};

} // namespace sync
} // namespace ipc
