### NAME

djbsort - sort array of integers or floating-point numbers

### SYNOPSIS

Using djbsort:

    #include <djbsort.h>

Link with `-ldjbsort`.

Sorting:

    int32_t x[n];
    ...
    djbsort_int32(x,n);
    djbsort_int32down(x,n);

    uint32_t x[n];
    ...
    djbsort_uint32(x,n);
    djbsort_uint32down(x,n);

    float x[n];
    ...
    djbsort_float32(x,n);
    djbsort_float32down(x,n);

    int64_t x[n];
    ...
    djbsort_int64(x,n);
    djbsort_int64down(x,n);

    uint64_t x[n];
    ...
    djbsort_uint64(x,n);
    djbsort_uint64down(x,n);

    double x[n];
    ...
    djbsort_float64(x,n);
    djbsort_float64down(x,n);

### DESCRIPTION

djbsort sorts an array `x` of `n` numeric elements,
placing the sorted result in the same array.
The `down` functions sort in reverse order.

The djbsort functions guarantee success:
they sort in place, not allocating memory beyond a small amount of stack space.

Each function returns without doing anything if `n` is `1` or `0`.
The `n` type is a signed `long long` and thus can also be negative,
in which case the function also returns without doing anything.
(For any sorting library,
a caller might sort all elements of a size-`n` array past the `m`th by sorting `x+m,n-m`;
but what happens if `n` happens to be smaller than `m`
and the caller does not check for this?
Returning immediately on negative inputs is much more likely to be the desired behavior
than crashing.
Beware that this still does not deal with the problem of caller arithmetic overflowing
if, e.g., `m` and `n` are `size_t` on a 32-bit machine.)

Each function guarantees that the outputs are exactly the inputs permuted into non-decreasing order,
or non-increasing order for the `down` functions.
Some sorting libraries do not provide this guarantee for floating-point arrays:
they might replace some types of NaNs with other types of NaNs,
or might even crash for floating-point inputs containing NaNs.

Other libraries include sorting functions that are typically slower than djbsort
but that have the flexibility of being able to sort other data types:
`heapsort` (in libc; sorts arbitrary types in place using a comparison callback);
`mergesort` (in libbsd; sorts arbitrary types using a comparison callback; typically faster than `heapsort` but does not sort in place);
`qsort` (in libc; sorts arbitrary types in place using a comparison callback; typically faster than `mergesort` but much slower for some inputs);
`radixsort` (in libbsd; sorts pointers to strings in place);
`std::sort` (in the C++ standard library; sorts arbitrary comparable types using templates).

### SEE ALSO

**djbsort-fulltest**(1),
**djbsort-speed**(1),
**djbsort-test**(1),
**heapsort**(3),
**mergesort**(3),
**qsort**(3),
**radixsort**(3)
